local P2xpos;
local P2ypos;
local P1, P2, jud1, jud2, com1, com2, P1Score, P2Score;

local songName = GAMESTATE:GetCurrentSong():GetSongDir() -- Looks for Song

local function handler_mod_internal(str, pn) -- Aplies Players options to not be disabled-
    local ps = GAMESTATE:GetPlayerState(pn)
    local pmods = ps:GetPlayerOptionsString('ModsLevel_Song')
    ps:SetPlayerOptions('ModsLevel_Song', pmods .. ', ' .. str)
    -- GAMESTATE:ApplyGameCommand('mod,'..str, pn)
end

local function handler_mod(str) -- Looks for many players are on the screen
    for i = 1, 2 do handler_mod_internal(str, 'PlayerNumber_P' .. i) end
end

local function handler_init() -- Useful for command shorcuts
    checked = false;
    if SCREENMAN:GetTopScreen():GetChild('Underlay'):GetChild('P1Score') then
        P1Score = SCREENMAN:GetTopScreen():GetChild('Underlay'):GetChild(
                      'P1Score')
    end
    if SCREENMAN:GetTopScreen():GetChild('Underlay'):GetChild('P2Score') then
        P2Score = SCREENMAN:GetTopScreen():GetChild('Underlay'):GetChild(
                      'P2Score')
    end

    -- lua course :D	/ timed mod management	
    curmod = 1;
    -- {beat,'mod'},
    mods = {

        }

    curmessage = 1;
    -- {beat,message,ignoreIfAhead}
    messages = {
        {26, "TransitionFire"}, 
        {168, "Cease"}
        -- {145, "HideSlick"},
        -- {179.75, "Caleb1"}, 
        -- {187.25, "Caleb2"},
        -- {195.25, "Caleb3"}, 
        -- {203.75, "Caleb4"},
        -- {226, "Slickback2"}, 
        -- {223.5, "Slickback3"}, 
        -- {248, "HideAll"}, 



        -- Lua messages go here, you can add them by using "MessageCommand= function(self)" after you inserted the name.

    }

end

local function handler_update() -- Updates the command to look for the players at the start of the song.

    if GAMESTATE:GetSongBeat() >= 0.1 and not checked then

        if SCREENMAN:GetTopScreen():GetChild('PlayerP1') then
            P1 = SCREENMAN:GetTopScreen():GetChild('PlayerP1')
        end

        if SCREENMAN:GetTopScreen():GetChild('PlayerP2') then
            P2 = SCREENMAN:GetTopScreen():GetChild('PlayerP2')
        end
        -- PE = SCREENMAN:GetTopScreen():GetChild('')

        screen = SCREENMAN:GetTopScreen()
        checked = true;

    end

    local beat = GAMESTATE:GetSongBeat()

    -- Collect all the mods that will be applied in this frame into one string.
    -- Mod tweening doesn't work correctly if the mods are in seperate commands.
    local mods_this_frame = {}
    local function add_mod(mod_str)
        mods_this_frame[#mods_this_frame + 1] = mod_str
    end
    local function execute_mods()
        if #mods_this_frame <= 0 then return end
        local total_mod_str = ""
        for i, ms in ipairs(mods_this_frame) do
            if #total_mod_str > 0 then
                total_mod_str = total_mod_str .. ", "
            end
            total_mod_str = total_mod_str .. ms
        end
        handler_mod(total_mod_str)
    end

    while curmod <= #mods and GAMESTATE:GetSongBeat() >= mods[curmod][1] do
        add_mod(mods[curmod][2])
        curmod = curmod + 1
    end

    execute_mods()

    -- SCREAMING GUMBALL
    while curmessage <= #messages and GAMESTATE:GetSongBeat() >=
        messages[curmessage][1] do
        if messages[curmessage][3] and GAMESTATE:GetSongBeat() >=
            messages[curmessage][1] + 5 then
            curmessage = curmessage + 1;
        else
            MESSAGEMAN:Broadcast(messages[curmessage][2])
            curmessage = curmessage + 1;
        end
    end
end

return Def.ActorFrame {

    OnCommand = function(self)
        handler_init()
        self:SetUpdateFunction(handler_update)
        local screen = SCREENMAN:GetTopScreen()
    end,
    Def.Quad {
        Name = "I may be sleeping, but I preserve the world.",
        InitCommand = cmd(visible, false),
        OnCommand = cmd(sleep, 1000)
    },
    LoadActor("Chandelier.mp4") .. {
        OnCommand = function(self)
            self:Center():zoom(0.5) --:diffusealpha(0):loop(false):rate(0)
        end,
        SlickbackMessageCommand = function(self)
            self:rate(1):loop(true):diffusealpha(1)
        end,
    },

}
